#version 330
#extension GL_EXT_gpu_shader4 : enable
//Eye of FleshMod01.fsh  by   ChuckNorris
 
//https://www.shadertoy.com/view/4l2yWW
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec4 noise(vec4 v){
    // ensure reasonable range
    v = fract(v) + fract(v*1e4) + fract(v*1e-4);
    // seed
    v += vec4(0.12345, 0.6789, 0.314159, 0.271828);
    // more iterations => more random
    v = fract(v*dot(v, v)*123.456);
    v = fract(v*dot(v, v)*123.456);
    v = fract(v*dot(v, v)*123.456);
    return v;
}

vec4 smooth_noise(vec4 v){
    vec4 iv = floor(v);
    vec4 u = v - iv;
    
    //u = u*u*(3.0 - 2.0*u);
    
    vec4 n0 = noise(iv + vec4(0, 0, 0, 0));
    vec4 n1 = noise(iv + vec4(1, 0, 0, 0));
    vec4 n2 = noise(iv + vec4(0, 1, 0, 0));
    vec4 n3 = noise(iv + vec4(1, 1, 0, 0));
    
    vec4 n4 = noise(iv + vec4(0, 0, 1, 0));
    vec4 n5 = noise(iv + vec4(1, 0, 1, 0));
    vec4 n6 = noise(iv + vec4(0, 1, 1, 0));
    vec4 n7 = noise(iv + vec4(1, 1, 1, 0));
    
    vec4 n8 = noise(iv + vec4(0, 0, 0, 1));
    vec4 n9 = noise(iv + vec4(1, 0, 0, 1));
    vec4 na = noise(iv + vec4(0, 1, 0, 1));
    vec4 nb = noise(iv + vec4(1, 1, 0, 1));
    
    vec4 nc = noise(iv + vec4(0, 0, 1, 1));
    vec4 nd = noise(iv + vec4(1, 0, 1, 1));
    vec4 ne = noise(iv + vec4(0, 1, 1, 1));
    vec4 nf = noise(iv + vec4(1, 1, 1, 1));
    
    vec4 n01 = mix(n0, n1, u.x);
    vec4 n23 = mix(n2, n3, u.x);
    vec4 n45 = mix(n4, n5, u.x);
    vec4 n67 = mix(n6, n7, u.x);
    vec4 n89 = mix(n8, n9, u.x);
    vec4 nab = mix(na, nb, u.x);
    vec4 ncd = mix(nc, nd, u.x);
    vec4 nef = mix(ne, nf, u.x);
    
    vec4 n0123 = mix(n01, n23, u.y);
    vec4 n4567 = mix(n45, n67, u.y);
    vec4 n89ab = mix(n89, nab, u.y);
    vec4 ncdef = mix(ncd, nef, u.y);
    
    vec4 n01234567 = mix(n0123, n4567, u.z);
    vec4 n89abcdef = mix(n89ab, ncdef, u.z);
    
    vec4 n = mix(n01234567, n89abcdef, u.w);
    
    return n;
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy*2.0 - 1.0;
    uv.x *= iResolution.x/iResolution.y;
    if (uv.x < 0.0) uv.x = -uv.x;
    
    float angle = atan(uv.y, uv.x);
    
    uv = vec2(angle, length(uv));
    
    vec4 result = vec4(0);
    const float n = 10.0;
    
    for (float i = 0.0; i < n; i++){
        vec4 r = smooth_noise(vec4(i, uv*20.0, iTime));
        
        vec2 offset = r.xy*2.0 - 1.0;
        
        offset *= r.z*0.02 + 0.05;
        
        float x = uv.x + offset.x;
        float y = uv.y + offset.y;

        float f = fract(x*5.0 + i/n);
        f -= 0.5;
        float u = 0.5;
        float spikyness = mix(10.0, 100.0, uv.y);
        f = exp(-spikyness*f*f);
        
		f = smoothstep(y, y + 0.1, f);
        if (uv.y > 1.0) f = 1.0;
        
        vec4 color = texture2D(iChannel0, vec2(x, y));
        
        result = mix(result, color, f);
    }
    
    result *= vec4(1, 0.9, 0.95, 1);
    
    gl_FragColor = result;
}